



/* eslint-disable no-unused-vars */
/**
 * @type EASFCApp
 * @private
 */
var _appMain = null;
/**
 *
 * @returns {IAppUrlVariables}
 */
function getUrlVars() {
    var vars = { locale: null, language: null, region: null, variant: null };
    var paramIndex = window.location.href.indexOf("?");
    var params = (paramIndex >= 0) ? window.location.href.slice(paramIndex + 1).split("&") : [];
    params.forEach(function (param) {
        var keyval = param.split("=");
        vars[keyval[0]] = keyval[1];
    });
    // if we have a locale
    var parts = [];
    if (vars.locale) {
        parts = vars.locale.split("_");
    }
    else {
        // attempt to read from path
        var re = /\/(en-uk|en-au|fr-fr|it-it|de-de|es-es|es-mx|nl-nl|pl-pl|ru-ru|ja-jp|pt-br|cs-cz|sv-se|da-dk|no-no|nb-no|nn-no|ko-kr|zh-cn|zh-hans-cn|zh-tw|zh-hant-tw|ar-sa|tr-tr)?\/fifa\/ultimate-team\//;
        var matches = re.exec(window.location.href);
        if (matches) {
            parts = matches[1].split("-");
        }
    }
    if (parts.length === 3) {
        vars.language = parts[0];
        vars.variant = parts[1];
        vars.region = parts[2];
    }
    else if (parts.length === 2) {
        vars.language = parts[0];
        vars.region = parts[1];
    }
    return vars;
}
/**
 * Checks if running a local chrome dev build.
 * @returns {boolean}
 * @public
 */
function isChrome() {
    var bool;
    
    bool = false;
    
    return bool;
}
/**
 * Checks if the current build is FUT Web
 * @returns {boolean}
 * @public
 */
function isWeb() {
    var bool;
    
    bool = false;
    
    return bool;
}
/**
 * Checks if we are running an android build
 * @returns {boolean}
 */
function isAndroid() {
    var bool;
    
    bool = true;
    
    return bool;
}
/**
 * Checks if we are running an iOS build
 * @returns {boolean}
 */
function isIOS() {
    var bool;
    
    bool = false;
    
    return bool;
}
/**
 * Checks if the build is running in IE.
 * @see https://stackoverflow.com/q/19999388
 * @returns {boolean}
 * @public
 */
function isIE() {
    /**
     * How to detect IE browser with Javascript
     */
    var ms_ie = false;
    var ua = window.navigator.userAgent;
    var old_ie = ua.indexOf("MSIE ");
    var new_ie = ua.indexOf("Trident/");
    if ((old_ie > -1) || (new_ie > -1)) {
        ms_ie = true;
    }
    return ms_ie;
}
/**
 * Check if the build is running in a phone browser.
 * @returns {boolean}
 * @public
 */
function isPhone() {
    var body = document.getElementsByTagName("body")[0];
    var isPortrait = DOMKit.hasClass(body, enums.UIDeviceTypes.PHONE);
    var isLandscape = DOMKit.hasClass(body, enums.UIDeviceTypes.LANDSCAPE);
    if (isPortrait || isLandscape) {
        // If we've already detected the device orientation, continue to use that
        // classification for consistency.
        return isPortrait;
    }
    else if (isWeb()) {
        // TODO: Attempting to support the web app on phones is messy right now;
        // should revisit this.
        return window.matchMedia("(max-device-width: 599px) and (orientation: portrait)").matches || window.matchMedia("(min-aspect-ratio: 32/19) and (max-device-width: 1023px) and " +
            "(orientation: landscape)").matches;
    }
    return window.matchMedia("(orientation: portrait)").matches;
}
/**
 * Retrieves the device UUID.
 * @returns {string}
 * @public
 */
function getUUID() {
    var uuid;
    
    uuid = window.device.uuid;
    
    return uuid;
}
/**
 * Retrieves the application object.
 * @returns {EASFCApp}
 * @public
 */
function getAppMain() {
    return _appMain;
}
/**
 * Retrieves the application storage object.
 * @returns {Object}
 * @public
 */
function getStorage() {
    return _appMain ? _appMain.getStorage() : localStorage;
}
/**
 * Called when the app receives a Push Notification.
 * @param {string} msgId A string identifier for the push notification that was received.
 * @param {string} url A deep link URL associated with the push notification.
 * @public
 */
/**
 * JS handler for functions sent from our native side.
 * @param {string} str A param received from native.
 */
function toJS(str) {
    DebugUtils.Assert(false, "Native code is trying to tell the web code something: " + str);
}
/**
 * MTX Catalog Handler
 * @param {string} catalog The entire catalog of MTX items.
 */
function onMTXCatalog(catalog) {
    if (_appMain && _appMain.onMTXCatalog) {
        _appMain.onMTXCatalog(JSON.parse(catalog));
    }
}
/**
 * MTX Transaction Handler
 * @param {string} transaction The MTX transaction.
 */
function onMTXTransaction(transaction) {
    if (_appMain && _appMain.onMTXTransaction) {
        _appMain.onMTXTransaction(JSON.parse(transaction));
    }
}
/**
 * MTX Item Granted Handler
 */
function onMTXItemGranted() {
    if (_appMain && _appMain.onMTXItemGranted) {
        _appMain.onMTXItemGranted();
    }
}
/**
 * MTX Error Handler
 * @param {string} error The MTX error.
 */
function onMTXError(error) {
    if (_appMain && _appMain.onMTXError) {
        _appMain.onMTXError(JSON.parse(error));
    }
}
/**
 * Push Notifications Handler
 * @param {string} msgId Push Notification message ID
 * @param {string} url Push Notification URL
 */
function onPN(msgId, url) {
    if (_appMain && _appMain.onPN) {
        _appMain.onPN(msgId, url);
    }
}
/**
 * Called when a deep link is received.
 * @param {string} url A deep link URL string.
 * @public
 */
function handleOpenURL(url) {
    if (_appMain) {
        _appMain.onHandleDeepLink(url);
    }
}
/**
 * Checks if the network connection is online.
 * @returns {boolean}
 * @public
 */
function hasConnection() {
    return navigator.onLine;
}
/**
 * Callback when the app is paused/dismissed to background.
 * @public
 */
function onAppPaused() {
    if (_appMain) {
        _appMain.onPause();
    }
}
/**
 * Called when the app is resumed/pushed to foreground.
 * @public
 */
function onAppResumed() {
    if (_appMain) {
        _appMain.onResume();
    }
}
/**
 * Handles visibility change events in the browser for FUT Web.
 * @param {Event} e The event that was triggered.
 * @public
 */
function onVisibilityChanged(e) {
    if (document.hidden) {
        onAppPaused();
    }
    else {
        onAppResumed();
    }
}
/**
 * Handles when the network comes online.
 * @public
 */
function onAppOnline() {
    if (_appMain) {
        _appMain.onOnline();
    }
}
/**
 * Handles when the network goes offline.
 * @public
 */
function onAppOffline() {
    if (_appMain) {
        _appMain.onOffline();
    }
}
/**
 * Handles when the window is about unload its resources.
 * @public
 */
function onBeforeUnload() {
    if (_appMain) {
        _appMain.onDestroy();
    }
}
/**
 * Checks if verbose debug logging is enabled.
 * @returns {boolean}
 * @public
 */
function isVerboseLoggingEnabled() {
    if (_appMain) {
        return _appMain.isVerboseLoggingEnabled();
    }
    return false;
}
/**
 * Gets the application version number.
 * @returns {string}
 * @public
 */
function getAppVersion() {
    if (_appMain) {
        return _appMain.getAppVersion();
    }
    return "0";
}
/**
 * Gets the app identification string.
 * @returns {string}
 * @public
 */
function getAppId() {
    if (_appMain) {
        return _appMain.getAppIdentifier();
    }
    return "com.ea.fifaultimate.inc";
}
/**
 * Gets the application sell ID.
 * @returns {number}
 * @public
 */
function getSellId() {
    if (_appMain) {
        return _appMain.getSellId();
    }
    return 0;
}
/**
 * Retrieves either a numeric or string mobile app store ID, depending on the platform.
 * @returns {string}
 * @public
 */
function getStoreId() {
    
    if (_appMain) {
        return _appMain.getAppIdentifier();
    }
    
    return 0;
}
/**
 * Retrieves the default notification dispatcher for the application.
 * @returns {UTNotificationDispatcher}
 * @public
 */
function getDefaultDispatcher() {
    if (_appMain) {
        return _appMain.getDefaultDispatcher();
    }
    return null;
}
/**
 * Retrieves the keyboard event controller instance for the application.
 * @returns {EAKeyboardEventController}
 * @public
 */
function getKeyboardEventController() {
    if (_appMain) {
        return _appMain.getKeyboardEventController();
    }
    return null;
}
/**
 * Retrieves the back button event controller instance for the application.
 * @returns {UTBackButtonEventController}
 * @public
 */
function getBackButtonEventController() {
    if (_appMain && _appMain.getBackButtonEventController) {
        return _appMain.getBackButtonEventController();
    }
    return null;
}
/**
 * Handles orientation change events.
 * @public
 */
function onOrientationChanged() {
    if (_appMain) {
        _appMain.onOrientationChanged();
    }
}
/**
 * Removes focus from the entire document.
 * @public
 */
function removeFocus() {
    if (document.activeElement && document.activeElement.nodeName.toLowerCase() !== "body") {
        document.activeElement.blur();
    }
}
/**
 * Shows the device keyboard.
 * @public
 */
function showKeyboard() {
    if (!isChrome() && cordova && cordova.plugins && cordova.plugins.Keyboard) {
        cordova.plugins.Keyboard.show();
    }
}
/**
 * Hides the device keyboard.
 * @public
 */
function hideKeyboard() {
    removeFocus();
    if (!isChrome() && cordova && cordova.plugins && cordova.plugins.Keyboard) {
        cordova.plugins.Keyboard.close();
    }
}
/**
 * When this function is called, PhoneGap has been initialized and is ready to roll
 * @public
 */
function onDeviceReady() {
    var tokenKey = "token";
    var expireKey = "expire";
    var showOffIdKey = "showoffId";
    console.log("onDeviceReady");
    
    document.addEventListener("pause", onAppPaused, false);
    document.addEventListener("resume", onAppResumed, false);
    
    window.addEventListener("orientationchange", onOrientationChanged, false);
    window.addEventListener("online", onAppOnline, false);
    window.addEventListener("offline", onAppOffline, false);
    
    _appMain = new EASFCApp_Android();
    
    _appMain.init();
    // Handle Show Off ID & deepLinkId if any was passed to the app during launch/onAppResume
    var showOffId = "";
    var deepLinkId = "";
    if (window.MobileAccessibility) {
        window.MobileAccessibility.usePreferredTextZoom(false);
        window.MobileAccessibility.setTextZoom(100);
    }
    
    if (!isChrome()) {
        window.universalLinks.subscribe("launchFromLink", function (eventData) {
            showOffId = eventData.params[showOffIdKey];
            if (showOffId) {
                _appMain.setUnauthenticatedShowOffId(showOffId);
            }
            // Check if there is a valid deep link param.
            deepLinkId = services.URL.findValidDeepLinkID(Object.keys(eventData.params));
            // If it exists, store it so we can use it.
            if (deepLinkId !== DeepLinkSection.NONE) {
                services.URL.setDeepLinkURL(deepLinkId, eventData.params[deepLinkId]);
                // If we're already inside the app and logged in, just process the deep link URL right away.
                var state = services.Authentication.getUtasSession().state;
                if (_appMain.isInitComplete() && state === AuthenticationState.AUTHENTICATED) {
                    services.URL.processDeepLinkURL();
                }
            }
        });
    }
    else {
        console.log("Check for URL params.");
        
    }
}
/**
 * Handles when the window received a message
 * @public
 */
function onMessage(event) {
    
    // in case ta response it acknowledged
    if (event && event.data && event.data.target_event) {
        
        if (event.data.target_event === "eadp_auth_success") {
            if (event.data.code) {
                eadpAuthSuccess(code);
            }
            return;
        }
    }
}

if (isChrome()) {
    document.addEventListener("DOMContentLoaded", onDeviceReady);
}
else {
    document.addEventListener("deviceready", onDeviceReady);
}

/* eslint-enable no-unused-vars */
